/*
 * Decompiled with CFR 0.152.
 */
package com.github.canbabel.canio.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FileList
implements ListModel {
    private List<File> files = new ArrayList<File>();
    private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

    public void addFile(File f) {
        this.files.add(f);
        int i = this.files.size();
        ListDataEvent e = new ListDataEvent(this, 1, i, i);
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(e);
        }
    }

    public void remove(int i) {
        this.files.remove(i);
        ListDataEvent e = new ListDataEvent(this, 2, i, i);
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(e);
        }
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    @Override
    public int getSize() {
        return this.files.size();
    }

    public Object getElementAt(int index) {
        return this.files.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void clear() {
        int oldsize = this.files.size();
        this.files.clear();
        ListDataEvent e = new ListDataEvent(this, 2, 0, oldsize - 1);
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(e);
        }
    }
}

