/*
 * Decompiled with CFR 0.152.
 */
package com.github.canbabel.canio.dbc;

import com.github.canbabel.canio.dbc.LabelComparator;
import com.github.canbabel.canio.kcd.BasicLabelType;
import com.github.canbabel.canio.kcd.BasicSignalType;
import com.github.canbabel.canio.kcd.Bus;
import com.github.canbabel.canio.kcd.Document;
import com.github.canbabel.canio.kcd.Label;
import com.github.canbabel.canio.kcd.LabelSet;
import com.github.canbabel.canio.kcd.Message;
import com.github.canbabel.canio.kcd.Multiplex;
import com.github.canbabel.canio.kcd.MuxGroup;
import com.github.canbabel.canio.kcd.NetworkDefinition;
import com.github.canbabel.canio.kcd.Node;
import com.github.canbabel.canio.kcd.NodeRef;
import com.github.canbabel.canio.kcd.ObjectFactory;
import com.github.canbabel.canio.kcd.Producer;
import com.github.canbabel.canio.kcd.Signal;
import com.github.canbabel.canio.kcd.Value;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class DbcReader {
    private static final String[] KEYWORDS = new String[]{"VERSION ", "NS_ : ", "BS_:", "BU_: ", "BO_ ", "SG_ ", "BO_TX_BU_ ", "CM_ ", "CM_ BO_ ", "CM_ EV_ ", "CM_ SG_ ", "BA_DEF_ ", "BA_DEF_ BU_ ", "BA_DEF_REL_ BU_SG_REL_ ", "BA_DEF_ SG_ ", "BA_DEF_DEF_ ", "BA_DEF_DEF_REL_ ", "BA_ ", "EV_ ", "VAL_ ", "VAL_TABLE_ ", "SIG_VALTYPE_ "};
    private static final String NOT_DEFINED = "Vector__XXX";
    private static final String ORPHANED_SIGNALS = "VECTOR__INDEPENDENT_SIG_MSG";
    private static final String DOC_CONTENT = "Converted with CANBabel (https://github.com/julietkilo/CANBabel)";
    private boolean isReadable;
    private Collection<String> nodes = new ArrayList<String>();
    private ObjectFactory factory = null;
    private NetworkDefinition network = null;
    private Document document = null;
    private Bus bus = null;
    private Map<Long, Set<Signal>> muxed = new TreeMap<Long, Set<Signal>>();
    private Set<LabelDescription> labels = new HashSet<LabelDescription>();
    private Set<SignalComment> signalComments = new HashSet<SignalComment>();
    private String version = "";
    private PrintWriter logWriter;

    private static Signal findSignal(List<Message> messages, long id, boolean e, String name) {
        for (Message message : messages) {
            boolean extended = "extended".equals(message.getFormat());
            if (Long.parseLong(message.getId().substring(2), 16) != id || extended != e) continue;
            List<Signal> signals = message.getSignal();
            for (Signal signal : signals) {
                if (!signal.getName().equals(name)) continue;
                return signal;
            }
            for (Multiplex multiplex : message.getMultiplex()) {
                for (MuxGroup group : multiplex.getMuxGroup()) {
                    for (Signal signal : group.getSignal()) {
                        if (!signal.getName().equals(name)) continue;
                        return signal;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseFile(File file, OutputStream logStream) {
        List<Message> messages;
        try {
            this.logWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(logStream, "ISO-8859-1")), true);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DbcReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.factory = new ObjectFactory();
        this.network = this.factory.createNetworkDefinition();
        this.document = this.factory.createDocument();
        this.document.setContent(DOC_CONTENT);
        this.document.setName(file.getName());
        Date now = Calendar.getInstance().getTime();
        this.document.setDate(now.toString());
        this.network.setDocument(this.document);
        this.bus = this.factory.createBus();
        this.bus.setName("Private");
        if (file.canRead() && file.exists()) {
            this.setReadable(true);
        }
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            String text;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
            boolean isFirstLine = true;
            while ((text = reader.readLine()) != null) {
                if (DbcReader.startsWithKeyword(text) && !isFirstLine) {
                    this.processLine(contents);
                    contents.delete(0, contents.length());
                }
                contents.append(text);
                isFirstLine = false;
            }
            this.network.getBus().add(this.bus);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(this.logWriter);
            boolean isFirstLine = false;
            return isFirstLine;
        }
        catch (IOException e) {
            e.printStackTrace(this.logWriter);
            boolean isFirstLine = false;
            return isFirstLine;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(this.logWriter);
                return false;
            }
        }
        for (LabelDescription description : this.labels) {
            messages = this.bus.getMessage();
            LabelSet set = new LabelSet();
            List<BasicLabelType> labellist = set.getLabelOrLabelGroup();
            labellist.addAll(description.getLabels());
            Signal signal = DbcReader.findSignal(messages, description.getId(), description.isExtended(), description.getSignalName());
            if (signal == null) continue;
            signal.setLabelSet(set);
        }
        for (SignalComment comment : this.signalComments) {
            messages = this.bus.getMessage();
            Signal signal = DbcReader.findSignal(messages, comment.getId(), comment.isExtended(), comment.getSignalName());
            if (signal == null) continue;
            signal.setNotes(comment.getComment());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeKcdFile(File file, boolean prettyPrint, boolean gzip) {
        Writer w = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{NetworkDefinition.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            if (prettyPrint) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if (gzip) {
                FileOutputStream fo = new FileOutputStream(file);
                GZIPOutputStream stream = new GZIPOutputStream(fo);
                w = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            } else {
                FileOutputStream fo = new FileOutputStream(file);
                w = new OutputStreamWriter((OutputStream)fo, "UTF-8");
            }
            marshaller.marshal((Object)this.network, w);
        }
        catch (JAXBException jxbe) {
            jxbe.printStackTrace(this.logWriter);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace(this.logWriter);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public List<String> getNodes() {
        return Collections.unmodifiableList((List)this.nodes);
    }

    private static boolean startsWithKeyword(String line) {
        boolean retval = false;
        for (int i = 0; i < KEYWORDS.length; ++i) {
            if (!line.startsWith(KEYWORDS[i])) continue;
            retval = true;
        }
        return retval;
    }

    private void processLine(StringBuffer line) {
        if (Pattern.matches("BO_.?\\d+.*", line)) {
            this.parseMessageDefinition(line);
        } else if (!Pattern.matches("VAL_TABLE_.*", line)) {
            if (Pattern.matches("VAL_.?\\d+.*", line)) {
                this.parseValueDescription(line);
            } else if (Pattern.matches("BA_DEF_.+\".*", line)) {
                DbcReader.parseAttribute(line);
            } else if (Pattern.matches("BA_\\s+\".*", line)) {
                DbcReader.parseAttribute(line);
            } else if (Pattern.matches("CM_ SG_.*", line)) {
                this.parseSignalComment(line);
            } else if (Pattern.matches("CM.*", line)) {
                DbcReader.parseComment(line);
            } else if (Pattern.matches("BO_TX_BU_.*", line)) {
                DbcReader.parseMessageTransmitter(line);
            } else if (Pattern.matches("BU_.*", line)) {
                this.parseNetworkNode(line);
            } else if (Pattern.matches("NS_.?:.*", line)) {
                DbcReader.parseNewSymbols(line);
            } else if (Pattern.matches("BS_.*", line)) {
                DbcReader.parseBitTimingSection(line);
            } else if (Pattern.matches("VERSION.*", line)) {
                this.parseVersion(line);
            } else if (Pattern.matches("EV_.*", line)) {
                this.parseEnvironmentVariable(line);
            } else if (Pattern.matches("VAL_.?\\w+.*", line)) {
                this.parseEnvironmentVariableDescription(line);
            } else {
                this.logWriter.write("Line does not match:'" + line + "'\n");
            }
        }
    }

    private void parseVersion(StringBuffer line) {
        String[] splitted = DbcReader.splitString(line.toString());
        this.version = splitted[1];
    }

    private static void parseBitTimingSection(StringBuffer line) {
    }

    private static void parseNewSymbols(StringBuffer line) {
    }

    private void parseNetworkNode(StringBuffer line) {
        line.replace(0, 5, "");
        line.trimToSize();
        String[] lineArray = line.toString().split("\\s+");
        this.nodes = Arrays.asList(lineArray);
        for (String nodeString : this.nodes) {
            Node node = this.factory.createNode();
            node.setId(nodeString);
            node.setName(nodeString);
            this.network.getNode().add(node);
        }
    }

    private static void parseMessageTransmitter(StringBuffer line) {
    }

    private static void parseComment(StringBuffer line) {
    }

    private static void parseAttribute(StringBuffer line) {
    }

    private void parseMessageDefinition(StringBuffer line) {
        this.muxed = new TreeMap<Long, Set<Signal>>();
        line.replace(0, 4, "");
        line.trimToSize();
        String[] lineArray = line.toString().split("\\s+SG_\\s+");
        String[] messageArray = lineArray[0].split("\\s+");
        Message message = this.factory.createMessage();
        int messageIdDecimal = this.getCanIdFromString(messageArray[0]);
        message.setId("0x" + Integer.toString(messageIdDecimal, 16).toUpperCase());
        if (this.isExtendedFrameFormat(messageArray[0])) {
            message.setFormat("extended");
        }
        message.setName(messageArray[1].replace(":", ""));
        message.setLength(messageArray[2]);
        if (!messageArray[3].contains(NOT_DEFINED)) {
            Producer producer = this.factory.createProducer();
            NodeRef ref = this.factory.createNodeRef();
            ref.setId(messageArray[3]);
            producer.getNodeRef().add(ref);
            message.setProducer(producer);
        }
        for (int i = 1; i < lineArray.length; ++i) {
            this.parseSignal(message, lineArray[i]);
        }
        if (this.muxed != null && this.muxed.size() > 0) {
            if (message.getMultiplex().size() == 1) {
                Multiplex mul = message.getMultiplex().get(0);
                List<MuxGroup> muxgroups = mul.getMuxGroup();
                for (Long i : this.muxed.keySet()) {
                    MuxGroup group = new MuxGroup();
                    group.setCount(i);
                    group.getSignal().addAll((Collection<Signal>)this.muxed.get(i));
                    muxgroups.add(group);
                }
            }
        } else {
            message.getMultiplex().clear();
        }
        if (!message.getName().contains(ORPHANED_SIGNALS)) {
            this.bus.getMessage().add(message);
        }
    }

    private void parseEnvironmentVariable(StringBuffer line) {
    }

    private void parseEnvironmentVariableDescription(StringBuffer line) {
    }

    private int getCanIdFromString(String canIdStr) {
        long canIdLong = Long.valueOf(canIdStr);
        int canId = (int)canIdLong & 0x1FFFFFFF;
        return canId;
    }

    private boolean isExtendedFrameFormat(String canIdStr) {
        long canIdLong = Long.valueOf(canIdStr);
        return (canIdLong >>> 31 & 1L) == 1L;
    }

    private Signal parseSignalLine(Message message, String signalName, SignalType type, String line) {
        Value value = null;
        BasicSignalType basicSignalType = this.factory.createBasicSignalType();
        basicSignalType.setName(signalName);
        String[] splitted = DbcReader.splitString(line);
        if (splitted != null) {
            basicSignalType.setOffset(Integer.parseInt(splitted[0]));
            if (!"1".equals(splitted[1])) {
                basicSignalType.setLength(Integer.parseInt(splitted[1]));
            }
            if ("0".equals(splitted[2])) {
                basicSignalType.setEndianess("big");
            }
            double slope = Double.valueOf(splitted[4]);
            double intercept = Double.valueOf(splitted[5]);
            double min = Double.valueOf(splitted[6]);
            double max = Double.valueOf(splitted[7]);
            if (intercept != 0.0 || slope != 1.0 || !"".equals(splitted[8]) || "-".equals(splitted[3]) || min != 0.0 || max != 1.0) {
                value = this.factory.createValue();
                if ("-".equals(splitted[3])) {
                    value.setType("signed");
                }
                if (slope != 1.0) {
                    value.setSlope(slope);
                }
                if (intercept != 0.0) {
                    value.setIntercept(intercept);
                }
                if (!"".equals(splitted[8])) {
                    value.setUnit(splitted[8]);
                }
                if (min != 0.0) {
                    value.setMin(min);
                }
                if (max != 1.0) {
                    value.setMax(max);
                }
            }
        }
        if (type == SignalType.MULTIPLEXOR) {
            Multiplex mux = this.factory.createMultiplex();
            mux.setName(basicSignalType.getName());
            mux.setOffset(basicSignalType.getOffset());
            if (basicSignalType.getLength() != 1) {
                mux.setLength(basicSignalType.getLength());
            }
            if ("big".equals(basicSignalType.getEndianess())) {
                mux.setEndianess(basicSignalType.getEndianess());
            }
            mux.setValue(value);
            message.getMultiplex().add(mux);
            return null;
        }
        Signal signal = this.factory.createSignal();
        signal.setName(basicSignalType.getName());
        signal.setOffset(basicSignalType.getOffset());
        if (basicSignalType.getLength() != 1) {
            signal.setLength(basicSignalType.getLength());
        }
        if ("big".equals(basicSignalType.getEndianess())) {
            signal.setEndianess(basicSignalType.getEndianess());
        }
        signal.setValue(value);
        message.getSignal().add(signal);
        return signal;
    }

    protected void parseSignal(Message message, String line) {
        String[] lineArray = line.split(":");
        String signalName = lineArray[0].toString().trim();
        if (Pattern.compile("\\w+\\s+\\w+").matcher(lineArray[0]).find()) {
            if (signalName.endsWith("M")) {
                this.parseSignalLine(message, signalName.substring(0, signalName.length() - 2), SignalType.MULTIPLEXOR, lineArray[1]);
            } else {
                String countstring = lineArray[0].trim();
                for (int i = countstring.length() - 1; i > 0; --i) {
                    if (countstring.charAt(i) != 'm') continue;
                    countstring = countstring.substring(i + 1);
                    break;
                }
                long muxcount = Long.parseLong(countstring);
                Signal signal = this.parseSignalLine(message, lineArray[0].split(" ")[0], SignalType.MULTIPLEX, lineArray[1]);
                Set<Signal> signalSet = this.muxed.get(muxcount);
                if (signalSet == null) {
                    signalSet = new HashSet<Signal>();
                    this.muxed.put(muxcount, signalSet);
                }
                signalSet.add(signal);
            }
        } else {
            this.parseSignalLine(message, signalName, SignalType.PLAIN, lineArray[1].toString().trim());
        }
    }

    private static boolean isDivider(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == '|' || c == ',' || c == '@' || c == ' ';
    }

    private static boolean isSymbol(char c) {
        return c == '+' || c == '-';
    }

    private static boolean isQuote(char c) {
        return c == '\"';
    }

    protected static String[] splitString(String s) {
        ArrayList<String> elements = new ArrayList<String>(10);
        String element = "";
        boolean inString = false;
        for (int i = 0; i < s.length(); ++i) {
            if (!inString && DbcReader.isDivider(s.charAt(i))) {
                if (!"".equals(element)) {
                    elements.add(element);
                }
                element = "";
                continue;
            }
            if (!inString && DbcReader.isSymbol(s.charAt(i))) {
                if (s.charAt(i - 2) == '@') {
                    elements.add(element);
                    element = "" + s.charAt(i);
                    continue;
                }
                element = element + s.charAt(i);
                continue;
            }
            if (DbcReader.isQuote(s.charAt(i))) {
                if (inString) {
                    elements.add(element);
                    element = "";
                    inString = false;
                    continue;
                }
                inString = true;
                continue;
            }
            element = element + s.charAt(i);
        }
        if (!"".equals(element)) {
            elements.add(element);
        }
        return elements.toArray(new String[elements.size()]);
    }

    private void setReadable(boolean isReadable) {
        this.isReadable = isReadable;
    }

    private void parseValueDescription(StringBuffer line) {
        String[] splitted = DbcReader.splitString(line.toString());
        LabelDescription description = new LabelDescription();
        if (this.isExtendedFrameFormat(splitted[1])) {
            description.setExtended(true);
        } else {
            description.setExtended(false);
        }
        description.setId(this.getCanIdFromString(splitted[1]));
        description.setSignalName(splitted[2]);
        TreeSet<Label> labelSet = new TreeSet<Label>(new LabelComparator());
        for (int i = 3; i < splitted.length - 1; i += 2) {
            Label label = new Label();
            label.setName(splitted[i + 1]);
            label.setValue(BigInteger.valueOf(Long.parseLong(splitted[i])));
            labelSet.add(label);
        }
        description.setLabels(labelSet);
        this.labels.add(description);
    }

    private void parseSignalComment(StringBuffer line) {
        String[] splitted = DbcReader.splitString(line.toString());
        SignalComment comment = new SignalComment();
        if (this.isExtendedFrameFormat(splitted[2])) {
            comment.setExtended(true);
        } else {
            comment.setExtended(false);
        }
        comment.setId(this.getCanIdFromString(splitted[2]));
        comment.setSignalName(splitted[3]);
        comment.setComment(splitted[4]);
        this.signalComments.add(comment);
    }

    private static enum SignalType {
        MULTIPLEXOR,
        MULTIPLEX,
        PLAIN;

    }

    private static class SignalComment {
        private long id;
        private String signalName;
        private String comment;
        private boolean extended;

        private SignalComment() {
        }

        public boolean isExtended() {
            return this.extended;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public void setSignalName(String signalName) {
            this.signalName = signalName;
        }
    }

    private static class LabelDescription {
        private long id;
        private String signalName;
        private Set<Label> labels;
        private boolean extended;

        private LabelDescription() {
        }

        public boolean isExtended() {
            return this.extended;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public Set<Label> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<Label> labels) {
            this.labels = labels;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public void setSignalName(String signalName) {
            this.signalName = signalName;
        }
    }
}

